/* Programme de recherche de chaines de caractères dans plusieurs fichiers
Programmé par Maniack Crudelis.
http://www.crudelis.fr
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
Version 1.0.*/
/*Copyright (c) 2008 Hervé Cottin.

Seek and found est un logiciel libre; vous pouvez le redistribuer et/ou le modifier selon les termes de la GNU General Public License (Licence Publique Générale GNU) telle qu'elle a été publiée par la Free Software Foundation; soit la version 3 de la licence, soit (comme vous le souhaitez) toute version ultérieure.

Seek and found est distribué dans l'espoir qu'il sera utile, mais SANS LA MOINDRE GARANTIE; pas même la garantie implicite de COMMERCIABILITE ou d'ADEQUATION A UN BUT PARTICULIER.
Voir la GNU General Public License pour plus de détails.

Vous devriez avoir reçu une copie de la GNU General Public License en même temps que ce programme; sinon, merci d'écrire à la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston, MA02111-1307 USA.*/

#include <stdio.h>
#include "Utilitaire.h"
#include "Chaines.h"
#include "Fichier.h"

int saisie_multi_chaines(char liste_chaines[250][255]);  //Prend la saisie et la répartie sur autant de string que nécessaire (max 250), renvoi le nombre de chaines
void ignore_casse (char chaine[255]);   //Change la chaine donnée en retirant les majuscules
int parseur_chaine (int max_ch, char liste_chaines[250][255], char chaines[250][255]);  //Découpe la saisie en chaines selon les espaces et les guillemets
int parseur_dossier (int max_ch, char liste_chaines[250][255], char dossiers[52][255]);  //Découpe la saisie en chaines selon les ; séparants les différents nom de dossier
int parseur_jokers (char chaine[255], char chaines_jokers[50][255]);  //Découpe la chaine donnée en chaines selon les *

int main (int argc,char *argv[])
{
    FILE* fichier1;
    FILE* fichier2;
    FILE* sortie;
    char liste_chaines[250][255];
    char chaines[250][255];
    char dossiers[52][255];
    char chaines_jokers[50][255];
    char chaine1[255];
    int casse[250];
    int max_ch, nb_dossiers, nb_ch, nb_ch_j,deb_fin;
    int i,j,k;
    int tabindex[50];
    Titre (argc,argv,"Seek and found","Programme de recherche de chaines de caractères dans plusieurs fichiers","02");
    //Initialisation des tableaux de chaines de caractère
    for(i=0;i<250;i++)
    {
        for(j=0;j<255;j++)
            liste_chaines[i][j] = '\0';
    }
    for(i=0;i<250;i++)
    {
        for(j=0;j<255;j++)
            chaines[i][j] = '\0';
    }
    for(i=0;i<52;i++)
    {
        for(j=0;j<255;j++)
            dossiers[i][j] = '\0';
    }
    for(i=0;i<250;i++)
        casse[i] = 0;
    puts("Indiquer le ou les dossiers dans lequels effectuer la recherche.");
    putsacc("  - Chaque dossier doit être séparé par ;.\n");
    putsacc("  - Pour lire aussi les sous dossiers, précéder le nom du dossier de -r-.\n");
    putsacc("  - Il est possible de donner une liste de fichiers depuis un fichier texte.\nDans ce cas, noter <'nomfichier' à la place d'un nom de dossier.\n");
    putsacc("  - Pour appliquer un filtre de recherche par type de fichier. Faire suivre le\nnom du dossier de :'type', on peut aussi appliquer plusieurs filtres de la\nmanière suivante :'type1':'type2'.\n");
    printf("\nListe des dossiers: ");
    max_ch = saisie_multi_chaines(liste_chaines);
    nb_dossiers = parseur_dossier(max_ch,liste_chaines,dossiers);
    system("echo Liste des fichiers: > liste_fichiers.txt");
    putsacc("Création de la liste des fichiers en cours...\n");
    for(i=0;i<nb_dossiers;i++)
    {
        if(dossiers[i][0] == '<')   //Commande indiquant une liste de fichier au format texte
        {   //ajout du contenu du fichier à la liste
            Efface_char(dossiers[i],"<");   //Efface la commande
            fichier1 = ouvre_fichier(dossiers[i],"r");
            fichier2 = ouvre_fichier("liste_fichiers.txt","a+");
            while(fgets(chaine1,255,fichier1) != NULL)  //Teste la fin de fichier pour ne pas doubler la dernière ligne
            {
                fprintf(fichier2,chaine1);
            };
            fclose(fichier1);
            fclose(fichier2);
        }
        else
        {   //listing du dossier spécifié
            j=0;
            if(dossiers[i][0] == '-' && dossiers[i][1] == 'r' && dossiers[i][2] == '-') //Commande de récursivité
            {
                Efface_char(dossiers[i],"-r-");   //Efface la commande du nom de dossier
                j=1; //Demande la commande de récursivité
            }
            sortie = ouvre_fichier("liste_fichiers.txt","a+"); //Ouvre le fichier pour écrire à la suite
            if(strstr(dossiers[i],":") != NULL)
            {   //Si présence de filtres à la suite du dossier
                strcpy(chaine1,strstr(dossiers[i],":"));    //Copie les filtres dans chaine1
                Efface_char(chaine1,":");   //Efface le : au début.
                k = index_ch_first(dossiers[i],":");  //Repére l'index du premier :
                dossiers[i][k] = '\0'; //Et termine la chaine au premier :
            }
            else
                chaine1[0] = '\0';  //Si pas de filtres, crée une chaine nulle.
            listing_doss(dossiers[i],sortie,j,chaine1); //Appel la commande de listing de dossier
            fclose(sortie);
        }
    }
    putsacc("\n\nIndiquer le ou les termes à rechercher.\n");
    putsacc("  - Chaque terme doit être séparé par un espace.\n");
    putsacc("  - Pour noter une chaine de caractères contenant des espaces, l'encadrer avec\ndes \"\".\n");
    putsacc("  - L'utilisation du joker, *, permet d'indiquer un nombre quelconques de\ncaractères inconnu.\n");
    putsacc("  - Pour ignorer la casse d'un terme de recherche, le précéder de -i-.\n");
    putsacc("  - L'option -I- (à la place de -i-) permet d'ignorer la casse de tous les\ntermes de recherche suivant.\n");
    putsacc("  - Pour rechercher plusieurs termes sur une même ligne, utiliser l'opérateur\nET, noté +.\n");
    putsacc("  - Pour indiquer qu'un terme doit être recherché en début de ligne, le précéder de -\\0-. Pour qu'il soit cherché en fin de ligne, le faire suivre de -\\0-.\n");
    putsacc("\nListe des termes recherchés: ");
    max_ch = saisie_multi_chaines(liste_chaines);
    nb_ch = parseur_chaine(max_ch,liste_chaines,chaines);
    for(i=0;i<nb_ch;i++)
    {
        if(strstr(chaines[i],"-i-") || strstr(chaines[i],"-I-")) //Commande pour ignorer casse
        {
            if(strstr(chaines[i],"-i-"))    //Si commande pour un seul mot (i minuscule)
                tabindex[1] = index_ch_first(chaines[i],"-i-");    //Localise la commande, tabindex[1] est utilisé en variable temporaire
            else
                tabindex[1] = index_ch_first(chaines[i],"-I-");    //Localise la commande, tabindex[1] est utilisé en variable temporaire
            j=i;  //La boucle for ne s'éxecutera que sur la chaine courante
            if(chaines[i][tabindex[1]+1] == 'I')
                j=nb_ch-1;    //Indique pas de casse pour tous les suivants. La boucle for s'éxécutera depuis la fin du tableau.
            for(tabindex[0]=0;tabindex[0]<3;tabindex[0]++)  //tabindex[0] est utilisé en variable de boucle
            {    //Efface la commande de la chaine
                k=tabindex[1];
                for(;k<strlen(chaines[i]);k++)
                    chaines[i][k] = chaines[i][k+1];
            }
            for(;j>=i;j--)  //La boucle for descend de j jusqu'à i.
            {
                ignore_casse(chaines[j]);   //Retire les majuscules de la chaine
                casse[j] = 1;   //tableau d'indic pas de maj pour ignorer aussi les chaines lues pour comparaison.
            }
        }
    }
    //Fin du traitement des données de l'utilisateur, début de recherche dans les fichiers
    fichier1 = ouvre_fichier("liste_fichiers.txt","r"); //Ouvre la liste des fichiers à traiter
    sortie = ouvre_fichier("Résultat recherche.txt","w");
    puts("");
    puts("Recherche en cours...");
    fgets(dossiers[0],255,fichier1); //Saute la 1ère ligne
    while(fgets(dossiers[0],255,fichier1) != NULL)  //Teste la fin de fichier pour ne pas doubler la dernière ligne
    {   //dossiers[0] est réutilisé pour stocker le chemin du fichier
        printf("Fichier en cours de lecture: %s", dossiers[0]);
        Efface_n(dossiers[0]);     /*Retire le \n*/
        fichier2 = ouvre_fichier(dossiers[0],"r"); //Ouvre le fichier à lire
        nb_dossiers=1;   //nb_dossier est réutilisé pour compter les lignes du fichier
        j=0;    //j à 0 indique un fichier où rien n'est trouvé
        while(fgets(chaine1,255,fichier2) != NULL)  //Teste la fin de fichier pour ne pas doubler la dernière ligne
        {   //Lit l'ensemble du fichier à lire
            for(max_ch=0;max_ch<nb_ch;max_ch++) //max_ch est utilisé en variable de boucle.
            {   //Boucle sur le nombre de chaine à chercher
                strcpy(liste_chaines[1],chaines[max_ch]);   //Pour ne pas modifier la chaine d'origine, on utilise une copie
                deb_fin = 0;
                if(liste_chaines[1][0] == '-' && liste_chaines[1][1] == '\\' && liste_chaines[1][2] == '0' && liste_chaines[1][3] == '-') //Indication de début de ligne
                {
                    Efface_char(liste_chaines[1],"-\\0-");   //Efface la commande de la chaine
                    deb_fin = -1;   //Indique chaine en début de ligne
                }
                i = strlen(liste_chaines[1]);
                if(liste_chaines[1][i-4] == '-' && liste_chaines[1][i-3] == '\\' && liste_chaines[1][i-2] == '0' && liste_chaines[1][i-1] == '-') //Indication de fin ou début de ligne
                {
                    liste_chaines[1][i-4] = '\0';   //Efface la commande de la chaine
                    deb_fin = 1;   //Indique chaine en fin de ligne
                }
                nb_ch_j = parseur_jokers(liste_chaines[1],chaines_jokers);    //Découpage de la chaine selon les jokers
                strcpy(liste_chaines[0],chaine1);   //Pour ne pas modifier la chaine d'origine, on utilise une copie
                if(casse[max_ch])   //Si pas de majuscule sur la chaine recherchée
                    ignore_casse(liste_chaines[0]);   //Retire les majuscules de la chaine
                transacc(liste_chaines[0]); //Corrige les accents dans la chaine lue pour éviter une erreur de comparaison
                for(i=0;i<nb_ch_j;i++)
                {   //Boucle sur les différents fragments créé par les jokers. Si pas de joker, un seul tour de boucle.
                    if(strstr(liste_chaines[0],chaines_jokers[i]) == NULL)  //Recherche dans la ligne les chaines parsé par joker
                        break;  //Si un seul élément n'est pas trouvé, la boucle s'arrête.
                    else
                    {   //Si la chaine est trouvée, vérification éventuelle de son emplacement
                        if(deb_fin == -1 && i==0)
                        {   //Début de ligne, test seulement sur le premier fragment de joker
                            k = index_ch_first(liste_chaines[0],chaines_jokers[i]);  //Donne l'enplacement de la première occurence de la chaine recherchée
                            if(k>0) //Début de ligne seulement si l'index est à 0
                                break;
                        }
                        else if(deb_fin == 1 && i==nb_ch_j-1)
                        {   //Fin de ligne, test seulement sur le dernier fragment de joker
                            k = index_ch(liste_chaines[0],chaines_jokers[i],tabindex);  //Donne l'enplacement de chaque occurence de la chaine recherchéeokers[i])]);
                            if(liste_chaines[0][tabindex[k-1]+strlen(chaines_jokers[i])] != '\0' && liste_chaines[0][tabindex[k-1]+strlen(chaines_jokers[i])] != '\n')
                                break;  //Fin de ligne seulement si après le terme recherché, il y a \0 ou \n
                        }
                    }
                }
                if(i == nb_ch_j)    //Si la boucle s'est terminée, celà signifie que tous les éléments ont été trouvé.
                {
                    if(!j)  //Si rien de trouvé dans le fichier
                    {
                        fprintf(sortie,"\n>>Fichier %s:\n", dossiers[0]); //Affiche le nom du fichier
                        j=1;   //Puis indique que le nom du fichier est déjà noté
                    }
                    fprintf(sortie,"Ligne %d: chaine '%s' trouvée.\n", nb_dossiers,liste_chaines[1]);
                }
            }
            nb_dossiers++;
        };
        fclose(fichier2);
    };
    fclose(fichier1);
    fclose(sortie);
//Affichage des résultats de la recherche
    puts("--------------------------------------------------------------------------------");
    putsacc("--                           Affichage des résultats                          --\n");
    sortie = ouvre_fichier("Résultat recherche.txt","r");
    while(fgets(chaine1,255,sortie) != NULL)  //Teste la fin de fichier pour ne pas doubler la dernière ligne
    {   //Lit l'ensemble du fichier du fichier de sortie et le duplique à l'écran
        putsacc(chaine1);
    };
    putsacc("\nLe résultat de la recherche à été dupliqué dans le fichier\n\"Résultat recherche.txt\" dans le dossier de Seek and found");
    fclose(sortie);
    Pause();
    return 0;
/*A venir
ET sur l'ensemble du fichier
Exclusion (cad recherche un terme mais pas un autre. Donc si "l'autre" est présent recherche négative) sur même ligne ou sur fichier complet.*/
}

void ignore_casse (char chaine[255])
{   //Change la chaine donnée en retirant les majuscules
    int i;
    for(i=0;i<strlen(chaine);i++)
        chaine[i] = tolower(chaine[i]);
}

int parseur_chaine (int max_ch, char liste_chaines[250][255], char chaines[250][255])
{  //Découpe la saisie en chaines selon les espaces et les guillemets
    int i,j,k=0,nb_chaines=0,guill=0;
    for(i=0;i<max_ch;i++)
    {   //Boucle sur nombre de chaines lues
        do
        {
            if(strlen(liste_chaines[i]) > 0)
            {   //Si chaine non vide et non lue entièrement
                j=0;
                do
                {
                    if(liste_chaines[i][j] == ' ' && guill == 1)    //Si espace au sein d'une chaine entre guillemets
                    {
                        chaines[nb_chaines][k++] = ' ';    //Ajoute l'espace à la chaine
                        j++;    //et incrémente j
                    }
                    for(;liste_chaines[i][j]!=' ' && liste_chaines[i][j]!='"' && liste_chaines[i][j]!='\0';j++)
                    {
                        chaines[nb_chaines][k++] = liste_chaines[i][j];
                    }
                    if(liste_chaines[i][j] == '"' && guill == 1)    //Si guill = 1, guillemets ouverts, donc fermeture de guillemet si " trouvé
                        break;//guill = 0;
                }while(liste_chaines[i][j] == ' ' && guill == 1); //Si espace, mais guillemet ouvert, continue à remplir la chaine
                if(liste_chaines[i][j] == '\0')    //Si fin de chaine
                {   //Fin de la chaine actuelle
                    break;
                }
                if(liste_chaines[i][j] == '"' && guill == 1)  //Fermeture du guillemet
                {   //Cloture de chaine entre guillemets
                    guill=0;
                    if(liste_chaines[i][j+1] == '-')    //Si une commande suit, juste après les guillemets
                    {
                        liste_chaines[i][j] = '0';  //Efface le " pour que la chaine ne soit pas coupée là.
                        for(j++;liste_chaines[i][j]!=' ' && liste_chaines[i][j]!='\0';j++)  //j++ en début permet d'ignorer le ". Continuer à copier jusqu'à l'espace ou la fin de chaine
                            chaines[nb_chaines][k++] = liste_chaines[i][j]; //Afin d'intégrer la commande à la chaine
                        liste_chaines[i][--j] = '"';  //Remplace le - de fin de commande par " pour que la chaine soit coupée là.
                    }
                    if(chaines[nb_chaines][0] != '\0')  //Evite de créer une chaine vide
                        nb_chaines++;
                    k=0;
                    Efface_char(liste_chaines[i],"\""); //Efface jusqu'au guillemet
                    Efface_char(liste_chaines[i]," "); //Efface l'espace (si il existe, donc pas à la fin de la chaine)
                }
                else if(liste_chaines[i][j] == '"' && guill == 0)  //Ouverture du guillemet
                {   //Ouverture de chaine entre guillemets
                    guill=1;
                    Efface_char(liste_chaines[i],"\""); //Efface jusqu'au guillemet
                }
                if(liste_chaines[i][j] == ' ')    //Si c'est un espace, pas de guillemet
                {   //Mot seul
                    if(chaines[nb_chaines][0] != '\0')  //Evite de créer une chaine vide
                        nb_chaines++;
                    k=0;
                    Efface_char(liste_chaines[i]," "); //Efface jusqu'à l'espace
                }
            }
            else   //Si chaine vide ou lue entièrement
                break;  //Fin de boucle
        }while(1);
    }
    if(chaines[nb_chaines][0] == '\0')  //Si la dernière chaine créée est une chaine vide (fin de chaine arrivée)
        nb_chaines--;   //Supprime la chaine vide
    return nb_chaines+1;
}

int parseur_dossier (int max_ch, char liste_chaines[250][255], char dossiers[52][255])
{  //Découpe la saisie en chaines selon les ; séparants les différents nom de dossier
    int nb_doss=0, i,j,k=0;
    for(i=0;i<max_ch;i++)
    {   //Boucle sur nombre de chaines lues
        do
        {
            j=0;    //Sert d'indicateur de reboucle while
            do
            { //Cette bcl while sert à terminer le dossier avant de l'envoyer dans le parseur de type de fichier. Afin d'éviter les erreurs
                if(j>0)
                    i++;    //Si j != 0, alors il y a eu reboucle du while, donc on passe à la chaine suivante dans liste_chaines
                if(strlen(liste_chaines[i]) > 0)
                {   //Si chaine non vide et non lue entièrement
                    for(j=0;liste_chaines[i][j]!=';' && liste_chaines[i][j]!='\0';j++)
                        dossiers[nb_doss][k++] = liste_chaines[i][j];
                }
            }while(liste_chaines[i][j]=='\0' && i<max_ch);  //Si fin de chaine atteinte et qu'il reste d'autres chaines en attente.
            dossiers[nb_doss][k] = '\0';    //Termine la chaine
            if(strstr(liste_chaines[i],";") != NULL)
            {
                Efface_char(liste_chaines[i],";");
                nb_doss++;
                k=0;
            }
            else   //Test la fin de liste
                break;
        }while(1);
    }
    return nb_doss+1;
}

int parseur_jokers (char chaine[255], char chaines_jokers[50][255])
{  //Découpe la chaine donnée en chaines selon les * et les +
    int i,j,nb_ch_jokers=0;
    int tabindex[50];
    char loc_chaine [255];
    strcpy(loc_chaine,chaine);  //Travaille sur une copie de la chaine envoyée pour ne pas l'altérer
    i = index_ch(loc_chaine,"+",tabindex);  //Donne l'enplacement de chaque occurence de +
    for(j=0;j<i;j++)    //La commande ET(+) fonctionne de la même manière que le joker.
        loc_chaine[tabindex[j]] = '*';  //Remplace toutes les occurences de + par *
    for(i=0;i<50;i++)
    {
        for(j=0;j<255;j++)
            chaines_jokers[i][j] = '\0';
    }
    do
    {
        if(strlen(loc_chaine) > 0)
        {   //Si chaine non vide et non lue entièrementf
            for(i=0;loc_chaine[i]!='*' && loc_chaine[i]!='\0';i++)
                chaines_jokers[nb_ch_jokers][i] = loc_chaine[i];
            chaines_jokers[nb_ch_jokers][i] = '\0'; //Termine la chaine
        }
        if(loc_chaine[i] == '\0' || loc_chaine[0] == '\0')   //Test la fin de liste
            break;
        if(strstr(loc_chaine,"*") != NULL)
        {
            Efface_char(loc_chaine,"*");
            nb_ch_jokers++;
        }
    }while(1);
    return nb_ch_jokers+1;
}

int saisie_multi_chaines(char liste_chaines[250][255])
{
    int nb_ch=0, nb_car=0;
    char caractere;
    while ((caractere = getchar()) != 10)
    {    /*Tant que l'utilisteur ne presse pas 'entrée'*/
        if (nb_car > 254)    //Si dépassement de la capacité de stockage de la string à 255
        {
            nb_ch++;    //Changement de string
            nb_car=0;
        }
        liste_chaines[nb_ch][nb_car++] = caractere;   /*Place le caractère à la suite de la chaine*/
    }
    liste_chaines[nb_ch][nb_car] = '\0'; //Termine la dernière string utilisée
    return (nb_ch+1);
}
